<?php
/* ******************************************************************
 * Generator Torgsoft sal file for opencart ocStore 3.0.x  version 2019-03-05
 * Copyright © FinBoss 2019
 * License: Commercial  
 ********************************************************************
 */

	@set_time_limit(0);
	
	error_reporting (E_ALL ^ ~E_DEPRECATED);
	
	header('Content-Type: text/html; charset=utf-8');
	
	$path_parts = pathinfo(__FILE__);				//	используется для установки пути
	$cron_prefix = $path_parts['dirname'].'/';		//	используется для установки пути
	
	// подключение библиотек
	require_once ($cron_prefix."./lib/DbSimple-i/Generic.php");
	
	if (file_exists($cron_prefix."../config.php")){
		// подключение к базе
		
		include_once ($cron_prefix."../config.php");
		
//		$DB = DbSimple_Generic::connect("mysqli://".DB_USERNAME.":".DB_PASSWORD."@".DB_HOSTNAME."/".DB_DATABASE);
		
		$parsed = array(
				'scheme' => 'mysqli',
				'host' => DB_HOSTNAME,
				'user' => DB_USERNAME,
				'pass' => DB_PASSWORD,
				'path' => "/".DB_DATABASE,
				'dsn'  => "mysqli://".DB_USERNAME.":".DB_PASSWORD."@".DB_HOSTNAME."/".DB_DATABASE
		);
		$DB = DbSimple_Generic::connect($parsed);
		
		if ($DB->errmsg){
			echo "Невозможно подключиться к базе данных";
			die();
		}
		
		// Устанавливаем обработчик ошибок.
		$DB->setErrorHandler('databaseErrorHandler');
		
		$DB->query("set character_set_client='utf8'");
		$DB->query("set character_set_results='utf8'");
		$DB->query("set collation_connection='utf8_bin'");
		
		$dbprefix = DB_PREFIX;
		
	}else{
		die ("Ошибка: Невозможно подключиться к базе данных");
	}
	
	
		
	$SQL = "SELECT
				* 
			FROM
				{$dbprefix}setting
			WHERE
				`code` = ?
			ORDER BY
				setting_id"; 
	$result = $DB->select($SQL, 'module_oc_loader_torgsoft');
	
	if ($result){

	}else{
		echo "Параметры модуля не установлены";
	}

	// проверка статуса модуля
	$oc_loader_torgsoft_status = config_get('oc_loader_torgsoft_20190305_status');
	if ($oc_loader_torgsoft_status != 1){
		die ("Ошибка: Статус модуля 'Отключен'");
	}
	
	$trs_dir = $cron_prefix.'../'.dirname(config_get('oc_loader_torgsoft_trs_file')).'/';
	$order_status_id = config_get('oc_loader_torgsoft_order_status_to_exchange');
	$order_status_new_id = config_get('oc_loader_torgsoft_order_status');
	
	if (is_dir($trs_dir)){
		write_orders();
	}else{
		die ("Ошибка: не найдена папка для записи файлов с заказами ".$trs_dir);
	}

// *************************************************************
	
	// вывод в файл
	function write_orders(){

		global 	$dbprefix, $DB, $cron_prefix, $trs_dir, $order_status_id, $order_status_new_id;
		
		// выборка заказов
		$SQL = "SELECT 
					order_id 
				FROM 
					`{$dbprefix}order`
				WHERE 
					order_status_id = ?
				";
		$result = $DB->query($SQL, $order_status_id);
		
		if ($result){
			
			foreach ($result as $result1){
				
				$order_id = $result1['order_id'];
				
				echo "\r\n<br />".$order_id;
				
				$order = getOrder($order_id);
				
				$date_array = explode('-', substr($order['date_added'], 0, strpos($order['date_added'], ' ')));
			
				// вывод в файл в кодировке 1251
				$file_name = $trs_dir.'order'.$order_id.'.sal';
				
				file_put_contents($file_name, "[Client]\r\n");	// (Блок информации о клиенте)
			
				file_put_contents($file_name, "Name=".iconv('UTF-8', 'CP1251//TRANSLIT', $order['firstname'].' '.$order['lastname'])."\r\n", FILE_APPEND);
				file_put_contents($file_name, "Mphone=".iconv('UTF-8', 'CP1251', $order['telephone'])."\r\n", FILE_APPEND);
				file_put_contents($file_name, "CPhone=".iconv('UTF-8', 'CP1251', $order['fax'])."\r\n", FILE_APPEND);
				file_put_contents($file_name, "ZIP=".iconv('UTF-8', 'CP1251', $order['payment_postcode'])."\r\n", FILE_APPEND);
				file_put_contents($file_name, "Country=".iconv('UTF-8', 'CP1251', $order['payment_country'])."\r\n", FILE_APPEND);
				file_put_contents($file_name, "Region=".iconv('UTF-8', 'CP1251', $order['payment_zone'])."\r\n", FILE_APPEND);
				file_put_contents($file_name, "City=".iconv('UTF-8', 'CP1251', $order['payment_city'])."\r\n", FILE_APPEND);
				file_put_contents($file_name, "Address=".iconv('UTF-8', 'CP1251//TRANSLIT', $order['shipping_address_1'].' '.$order['shipping_address_2'])."\r\n", FILE_APPEND);
				file_put_contents($file_name, "EMail=".iconv('UTF-8', 'CP1251', $order['email'])."\r\n", FILE_APPEND);
				
				file_put_contents($file_name, "\r\n", FILE_APPEND);
				
				file_put_contents($file_name, "[Options]\r\n", FILE_APPEND); // (Блок информации о заказе)
				file_put_contents($file_name, "OrderNumber=".iconv('UTF-8', 'CP1251', $order_id)."\r\n", FILE_APPEND);
				file_put_contents($file_name, "Comment=".iconv('UTF-8', 'CP1251//TRANSLIT', $order['comment'])."\r\n", FILE_APPEND);
				file_put_contents($file_name, "DeliveryCondition=".iconv('UTF-8', 'CP1251', $order['shipping_method'])."\r\n", FILE_APPEND);
				file_put_contents($file_name, "ReserveDate=".iconv('UTF-8', 'CP1251', $date_array[2].$date_array[1].$date_array[0])."\r\n", FILE_APPEND);
				file_put_contents($file_name, "SaleType=".iconv('UTF-8', 'CP1251', '1')."\r\n", FILE_APPEND);
				
				$SQL = "SELECT
							p.GoodID,
							op.product_id,
							op.quantity,
							op.price,
							op.order_product_id   
						FROM
							{$dbprefix}order_product as op
								LEFT JOIN {$dbprefix}product as p ON (p.product_id = op.product_id)
						WHERE
							op.order_id = ?
						";
				$products = $DB->query($SQL, $order_id);
				
				$p = 1;
				
				$related = array();
				
				foreach ($products as $product){
					
					$out = false;
					
					// определение опции и её GoodID
					$SQL = "SELECT 
								product_option_id,
								product_option_value_id,
								value 
							FROM 
								`{$dbprefix}order_option`
							WHERE
								order_product_id  = ?";
					$result = $DB->query($SQL, $product['order_product_id']);
					
					if ($result){
						
						if (count($result) == 1){
						
							$size = $result[0]['value'];
							$product_option_id = $result[0]['product_option_id'];
							$product_price = $product['price'];
							
							$SQL = "SELECT 
										pov.GoodID,
										pov.price,
										pov.price_prefix
									FROM 
										`{$dbprefix}product_option_value` as pov,
										`{$dbprefix}option_value_description` as ovd
									WHERE
										pov.product_option_id = ?
										AND
										pov.product_id = ?
										AND
										pov.option_value_id = ovd.option_value_id
										AND
										ovd.name = ?
									";
							$result = $DB->query($SQL, $product_option_id, $product['product_id'], $size);
							
							if ($result){
								
								$out = true;
								
								$result = $result[0];
								$price = $result['price'];
								$price_prefix = $result['price_prefix'];
								
								switch ($price_prefix){
									
									case '+':
										$product_price = $product_price + $price;
										break;
										
									case '-':
										$product_price = $product_price - $price;
										break;
										
									default:
										$product_price = $price;	// специальная доработка в движке для '='
										break;
								}
								
								file_put_contents($file_name, "\r\n", FILE_APPEND);
								file_put_contents($file_name, "[$p]\r\n", FILE_APPEND); // (Блок информации о первом товаре заказа)
								file_put_contents($file_name, "GoodID=".iconv('UTF-8', 'CP1251', $result['GoodID'])."\r\n", FILE_APPEND);  // (Ключ товара)
								file_put_contents($file_name, "Price=".iconv('UTF-8', 'CP1251', $product_price)."\r\n", FILE_APPEND); // (Цена продажи товара)
								file_put_contents($file_name, "Count=".iconv('UTF-8', 'CP1251', $product['quantity'])."\r\n", FILE_APPEND); // (Количество заказанного товара)
								
							}
						
						}else{
							
							// несколько опций - подразумеваем наличие модуля - Связанные опции
							
							$oc_loader_torgsoft_options_variant = (int)config_get('oc_loader_torgsoft_options_variant');
							
							if ($oc_loader_torgsoft_options_variant != 0){
								
								$product_option_ids = array();
								$i = 0;
								foreach ($result as $result1){
									
									$SQL = "SELECT
												*
											FROM
												`{$dbprefix}product_option`
											WHERE
												product_option_id = ?";
									$result_po = $DB->query($SQL, $result1['product_option_id']);
									
									if ($result_po){
										
										$product_option_ids[$i]['option_id'] = $result_po[0]['option_id'];
										
										$SQL = "SELECT
													*
												FROM
													`{$dbprefix}product_option_value`
												WHERE
													product_option_value_id = ?";
										$result_pov = $DB->query($SQL, $result1['product_option_value_id']);
										
										if ($result_pov){
											$product_option_ids[$i]['option_value_id'] = $result_pov[0]['option_value_id'];
											$i++;
										}else{
											echo "\r\n<br />Ошибка: не удадось найти значение опции - заказ $order_id product_id=".$product['product_id'];
										}
									}else{
										echo "\r\n<br />Ошибка: не удадось найти опцию - заказ $order_id product_id=".$product['product_id'];
									}
								}
								
								// последовательно выходим на комбинацию
								$relatedoptions_id = 0;
								$relatedoptions_ids = array();
								foreach ($product_option_ids as $i => $parameter){
									
									$SQL = "SELECT
												*
											FROM
												`{$dbprefix}relatedoptions_option`
											WHERE
												product_id = ?
												AND
												option_id =?
												AND
												option_value_id = ?";
									
									if (count($relatedoptions_ids) > 0){
										$SQL .= " AND relatedoptions_id IN (".implode(',', $relatedoptions_ids).")";
									}
									
									$result_ro = $DB->query($SQL, $product['product_id'], $parameter['option_id'], $parameter['option_value_id']);
								
									if (count($result_ro) == 1){
										$relatedoptions_id = $result_ro[0]['relatedoptions_id'];
										break;
									}else{
										
										if (count($result_ro) == 0){
											echo "\r\n<br />Ошибка: не удалось найти связанную опцию - заказ $order_id product_id=".$product['product_id'];
											break;
										}else{
											$relatedoptions_ids = array();
											
											foreach ($result_ro as $result_ro1){
												$relatedoptions_ids[] = $result_ro1['relatedoptions_id'];
											}
										}
									}
								}
								
								if ($relatedoptions_id != 0){
									
									$SQL = "SELECT
												*
											FROM
												`{$dbprefix}relatedoptions`
											WHERE
												relatedoptions_id = ?";
									$result_r = $DB->query($SQL, $relatedoptions_id);
									
									if ($result_r){
										
										if (!in_array($result_r[0]['GoodID'], $related)){
										
											file_put_contents($file_name, "\r\n", FILE_APPEND);
											file_put_contents($file_name, "[$p]\r\n", FILE_APPEND); // (Блок информации о первом товаре заказа)
											file_put_contents($file_name, "GoodID=".iconv('UTF-8', 'CP1251', $result_r[0]['GoodID'])."\r\n", FILE_APPEND);  // (Ключ товара)
											file_put_contents($file_name, "Price=".iconv('UTF-8', 'CP1251', $product['price'])."\r\n", FILE_APPEND); // (Цена продажи товара)
											file_put_contents($file_name, "Count=".iconv('UTF-8', 'CP1251', $product['quantity'])."\r\n", FILE_APPEND); // (Количество заказанного товара)
											
											$related[] = $result_r[0]['GoodID'];
											
											$out = true;
										
										}
									}else{
										echo "\r\n<br />Ошибка: не удалось найти связанную опцию $relatedoptions_id - заказ $order_id product_id=".$product['product_id'];
									}
								}
								
							}else{
								echo "\r\n<br />Ошибка: у товара несколько опций, а модуль Связанные опции не установлен - заказ $order_id product_id=".$product['product_id'];
							}
							
						}
						
					}
					
					
					if ($out == false){
						file_put_contents($file_name, "\r\n", FILE_APPEND);
						file_put_contents($file_name, "[$p]\r\n", FILE_APPEND); // (Блок информации о первом товаре заказа)
						file_put_contents($file_name, "GoodID=".iconv('UTF-8', 'CP1251', $product['GoodID'])."\r\n", FILE_APPEND);  // (Ключ товара)
						file_put_contents($file_name, "Price=".iconv('UTF-8', 'CP1251', $product['price'])."\r\n", FILE_APPEND); // (Цена продажи товара)
						file_put_contents($file_name, "Count=".iconv('UTF-8', 'CP1251', $product['quantity'])."\r\n", FILE_APPEND); // (Количество заказанного товара)
					
					}
					$p++;
				}
				
				$SQL = "UPDATE
							`{$dbprefix}order`
						SET
							order_status_id = ?
						WHERE
							order_id = ?
						";
				$DB->query($SQL, $order_status_new_id, $order_id);
				
				$SQL = "INSERT INTO 
							`{$dbprefix}order_history` 
							(`order_id`, `order_status_id`, `notify`, `comment`, `date_added`) VALUES
							(         ?,                 ?,        0,         ?,        NOW());";
				$DB->query($SQL, $order_id, $order_status_new_id, date('Y-m-d H:i:s'));
				
				chmod($file_name, 0775);
			}
			
		}else{
			echo 'Нет заказов со статусом: '.$order_status_id;
		}

	}
	
	function getOrder($order_id) {
		
		global 	$dbprefix, $DB;
		
		$SQL = ("SELECT *, (SELECT CONCAT(c.firstname, ' ', c.lastname) FROM " . DB_PREFIX . "customer c WHERE c.customer_id = o.customer_id) AS customer FROM `" . DB_PREFIX . "order` o WHERE o.order_id = '" . (int)$order_id . "'");
		$order_query = $DB->query($SQL);
		
		return array(
			'order_id'                => $order_query[0]['order_id'],
			'firstname'               => $order_query[0]['firstname'],
			'lastname'                => $order_query[0]['lastname'],
			'telephone'               => $order_query[0]['telephone'],
			'fax'                     => $order_query[0]['fax'],
			'email'                   => $order_query[0]['email'],
			'payment_postcode'        => $order_query[0]['payment_postcode'],
			'payment_city'            => $order_query[0]['payment_city'],
			'payment_zone'            => $order_query[0]['payment_zone'],
			'payment_country'         => $order_query[0]['payment_country'],
			'shipping_address_1'      => $order_query[0]['shipping_address_1'],
			'shipping_address_2'      => $order_query[0]['shipping_address_2'],
			'shipping_method'         => $order_query[0]['shipping_method'],
			'comment'                 => $order_query[0]['comment'],
			'date_added'              => $order_query[0]['date_added'],
		);
		
	}

//*********************************************** служебные функции

// Обработчик ошибок SQL
function databaseErrorHandler($message, $info)
{
    // Если использовалась @, ничего не делать.
    //if (!error_reporting()) return;
    // Выводим подробную информацию об ошибке.
    echo "SQL Error: $message<br><pre>"; 
    print_r($info);
    echo "</pre>";
    exit();
}

function config_get($key){
	
	global $config, $DB, $dbprefix;
	
	if (isset($config[$key])){
		return $config[$key];
	}else{
		
		if (strpos($key, 'oc_loader_torgsoft') !== false){
			$new_key = 'module_'.$key;
		}else{
			$new_key = $key;
		}
		
		$SQL = "SELECT
					value 
				FROM
					{$dbprefix}setting
				WHERE
					`key` = ?
				"; 
		$result = $DB->select($SQL, $new_key);
		if ($result){
			$config[$key] = $result[0]['value'];
			return $config[$key];
		}else{
			return false;
		}
	
	}
}

function curl_get_contents($url, array $get = array(), array $options = array())
{    
	
    $defaults = array(
       CURLOPT_URL => $url. (strpos($url, '?') === FALSE ? '?' : ''). http_build_query($get),
       CURLOPT_HEADER => 0,
       CURLOPT_RETURNTRANSFER => TRUE,
       CURLOPT_FOLLOWLOCATION => 1,
       CURLOPT_TIMEOUT => 60,
       CURLOPT_SSL_VERIFYPEER => false
    );
   
    $ch = curl_init();
    curl_setopt_array($ch, ($options + $defaults));
	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.1.2) Gecko/20090729 Firefox/3.5.2 GTB5');
    if(!$result = curl_exec($ch)) {
       	trigger_error(curl_error($ch));
		$result = 'error: '.curl_error($ch);
    }else{
    	//echo 'OK';
    }
    curl_close($ch);
   
    return $result;
}